/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsSystemState extends JavaScriptObject {

	protected JsSystemState() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsSystemState CORE_STATE_STARTING()
	/*-{
		return "CORE_STATE_STARTING";
	}-*/;

	public static final native JsSystemState CORE_STATE_RUNNING()
	/*-{
		return "CORE_STATE_RUNNING";
	}-*/;

	public static final native JsSystemState CORE_STATE_MAINTENANCE()
	/*-{
		return "CORE_STATE_MAINTENANCE";
	}-*/;

	public static final native JsSystemState CORE_STATE_DEMOTED()
	/*-{
		return "CORE_STATE_DEMOTED";
	}-*/;

	public static final native JsSystemState CORE_STATE_NOT_INSTALLED()
	/*-{
		return "CORE_STATE_NOT_INSTALLED";
	}-*/;

	public static final native JsSystemState CORE_STATE_UPGRADE()
	/*-{
		return "CORE_STATE_UPGRADE";
	}-*/;

	public static final native JsSystemState CORE_STATE_CLONING()
	/*-{
		return "CORE_STATE_CLONING";
	}-*/;

	public static final native JsSystemState CORE_STATE_STOPPING()
	/*-{
		return "CORE_STATE_STOPPING";
	}-*/;

	public static final native JsSystemState CORE_STATE_UNKNOWN()
	/*-{
		return "CORE_STATE_UNKNOWN";
	}-*/;

	public static final JsSystemState create(net.bluemind.system.api.SystemState value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case CORE_STATE_STARTING:
				return CORE_STATE_STARTING();
			case CORE_STATE_RUNNING:
				return CORE_STATE_RUNNING();
			case CORE_STATE_MAINTENANCE:
				return CORE_STATE_MAINTENANCE();
			case CORE_STATE_DEMOTED:
				return CORE_STATE_DEMOTED();
			case CORE_STATE_NOT_INSTALLED:
				return CORE_STATE_NOT_INSTALLED();
			case CORE_STATE_UPGRADE:
				return CORE_STATE_UPGRADE();
			case CORE_STATE_CLONING:
				return CORE_STATE_CLONING();
			case CORE_STATE_STOPPING:
				return CORE_STATE_STOPPING();
			case CORE_STATE_UNKNOWN:
				return CORE_STATE_UNKNOWN();
			default:
				return null;
			}
		}
	}
}