/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.system.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsConnectionTestStatus extends JavaScriptObject {

	protected JsConnectionTestStatus() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsConnectionTestStatus OK()
	/*-{
		return "OK";
	}-*/;

	public static final native JsConnectionTestStatus NOK()
	/*-{
		return "NOK";
	}-*/;

	public static final native JsConnectionTestStatus NOT_SUPPORTED()
	/*-{
		return "NOT_SUPPORTED";
	}-*/;

	public static final JsConnectionTestStatus create(net.bluemind.system.api.ConnectionTestStatus value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case OK:
				return OK();
			case NOK:
				return NOK();
			case NOT_SUPPORTED:
				return NOT_SUPPORTED();
			default:
				return null;
			}
		}
	}
}