import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './WebAppDataClient.json';

export class WebAppDataClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/webappdata/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async allUids( __fetchOptions = {}) {
        let __path = this.base + '/_alluids';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async create(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/uid/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async delete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/uid/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteAll( __fetchOptions = {}) {
        let __path = this.base + '/_deleteAll';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getByKey(key,  __fetchOptions = {}) {
        let __path = this.base + '/key/{key}';
        __path = __path.replace('{key}', encodeURIComponent(key));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/uid/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async itemChangelog(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_itemchangelog';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleGet(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/uid/_mget';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async multipleGetById(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async update(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/uid/{uid}';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
