import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IUserSettings {
    /**
     * Get {@link User} settings
     * @param uid uid of the user
     * @returns &lt;Map&lt;String, String>> user settings
     */
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    /**
     * Get one {@link User} setting value
     * @param uid uid of the user
     * @param name setting name
     * @returns String setting value
     */
    getOne(uid: string, name: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Set {@link User} settings
     * @param uid uid of the user
     * @param settings settings values
     */
    set(uid: string, settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Create or update one {@link User} setting
     * @param uid uid of the user
     * @param name setting name
     * @param value setting value
     */
    setOne(uid: string, name: string, value?: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserSettingsClient extends ApiEndPoint implements IUserSettings {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    get(uid: string,  __fetchOptions?: RequestOptions): Promise<Record<string, string>>;
    getOne(uid: string, name: string,  __fetchOptions?: RequestOptions): Promise<string>;
    set(uid: string, settings?: Record<string, string>,  __fetchOptions?: RequestOptions): Promise<void>;
    setOne(uid: string, name: string, value?: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
