
import { UserAccountInfo } from "./UserAccountInfo"; 
import { UserAccount } from "./UserAccount"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * {@link UserAccount} API.
 * 
 * Handles external user accounts. [uid] corresponds to an user uid.
 * [systemIdentifier] is used to identify the external system and is usually
 * predetermined by the corresponding plugin.
 */
export interface IUserExternalAccount {
    create(system: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(system: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    get(system: string,  __fetchOptions?: RequestOptions): Promise<UserAccount>;
    getAll( __fetchOptions?: RequestOptions): Promise<Array<UserAccountInfo>>;
    update(system: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class UserExternalAccountClient extends ApiEndPoint implements IUserExternalAccount {
    domain: string;
    uid: string;
    constructor(apiKey: string, domain: string, uid: string, base?: string);
    create(system: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(system: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    get(system: string,  __fetchOptions?: RequestOptions): Promise<UserAccount>;
    getAll( __fetchOptions?: RequestOptions): Promise<Array<UserAccountInfo>>;
    update(system: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
