import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific todolist container UIDs
 */
export interface ITodoUids {
    /**
     * Returns the default user todolist UID
     * @param uid the {@link net.bluemind.user.api.User} UID
     * @returns default user todolist UID
     */
    getDefaultUserTodoList(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    /**
     * Returns the UID of user-created todolists
     * @returns calendar UID
     */
    getUserCreatedTodoList(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class TodoUidsClient extends ApiEndPoint implements ITodoUids {
    constructor(apiKey: string, base?: string);
    getDefaultUserTodoList(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getUserCreatedTodoList(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
