import { 
    ItemContainerValue,
    ContainerDescriptor
} from "@bluemind/core.container.api";

import { VTodo } from "./VTodo"; 
import { TodoListsVTodoQuery } from "./TodoListsVTodoQuery"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Todolist management API. See {@link ITodoUids} on how to create the unique
 * UIDs.
 */
export interface ITodoLists {
    /**
     * Create a todolist + auto-subscribe + set ALL necessary Access-Control-List
     * entries
     * @param uid Unique UID according to {@link ITodoUids}
     * @param descriptor Todolist values
     */
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Delete a Todolist and all containing {@link IVTodo}s
     * @param uid Unique UID
     */
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    /**
     * Returns a {@link ListResult} of {@link ItemValue}s containing {@link VEvent}s
     * @param query {@link TodoListsVTodoQuery}
     * @returns {@link ListResult} of {@link ItemValue}s containing {@link VEvent}s
     */
    search(query?: TodoListsVTodoQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VTodo>>>;
}

export declare class TodoListsClient extends ApiEndPoint implements ITodoLists {
    constructor(apiKey: string, base?: string);
    create(uid: string, descriptor?: ContainerDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    search(query?: TodoListsVTodoQuery,  __fetchOptions?: RequestOptions): Promise<Array<ItemContainerValue<VTodo>>>;
    getMetadata(): EndPointMetadata;
}
