import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific tags container UIDs
 */
export interface ITagUids {
    /**
     * Returns the default user tag UID
     * @returns default user tag UID
     */
    getDefaultUserTags(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class TagUidsClient extends ApiEndPoint implements ITagUids {
    constructor(apiKey: string, base?: string);
    getDefaultUserTags(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
