import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './HotUpgradeClient.json';

export class HotUpgradeClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/hot_upgrade');
    }
    async list(filter,  __fetchOptions = {}) {
        let __path = this.base + '/list';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (filter != null) {
            __options.body = JSON.stringify(filter);
        }
		return this.__fetchContent(__url, __options);
    }
    async progress( __fetchOptions = {}) {
        let __path = this.base + '/progress';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async running( __fetchOptions = {}) {
        let __path = this.base + '/running';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
