
import { ConnectionTestStatus } from "./ConnectionTestStatus"; 
import { ExternalSystem } from "./ExternalSystem"; 
import { 
    UserAccount
} from "@bluemind/user.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IExternalSystem {
    getExternalSystem(systemIdentifier: string,  __fetchOptions?: RequestOptions): Promise<ExternalSystem>;
    getExternalSystems( __fetchOptions?: RequestOptions): Promise<Array<ExternalSystem>>;
    getExternalSystemsByAuthKind(authKinds?: Array<ExternalSystem.AuthKind>,  __fetchOptions?: RequestOptions): Promise<Array<ExternalSystem>>;
    getLogo(systemIdentifier: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    testConnection(systemIdentifier: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<ConnectionTestStatus>;
}

export declare class ExternalSystemClient extends ApiEndPoint implements IExternalSystem {
    constructor(apiKey: string, base?: string);
    getExternalSystem(systemIdentifier: string,  __fetchOptions?: RequestOptions): Promise<ExternalSystem>;
    getExternalSystems( __fetchOptions?: RequestOptions): Promise<Array<ExternalSystem>>;
    getExternalSystemsByAuthKind(authKinds?: Array<ExternalSystem.AuthKind>,  __fetchOptions?: RequestOptions): Promise<Array<ExternalSystem>>;
    getLogo(systemIdentifier: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    testConnection(systemIdentifier: string, account?: UserAccount,  __fetchOptions?: RequestOptions): Promise<ConnectionTestStatus>;
    getMetadata(): EndPointMetadata;
}
