
import { Credential } from "./Credential"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface ICredentials {
    getObfuscatedUserCredentials(userUid: string,  __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    /**
     * Remove user credential from its ID<br/>
     * 
     * Used by bm-keycloak to store credentials
     * @param credentialId 
     */
    removeUserCredential(userUid: string, credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class CredentialsClient extends ApiEndPoint implements ICredentials {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    getObfuscatedUserCredentials(userUid: string,  __fetchOptions?: RequestOptions): Promise<ListResult<Credential>>;
    removeUserCredential(userUid: string, credentialId: string,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
