
import { RoleDescriptor } from "./RoleDescriptor"; 
import { RolesCategory } from "./RolesCategory"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Role API.
 */
export interface IRoles {
    /**
     * Get all available and visible {@link RoleDescriptor}.
     * @returns Set of {@link RoleDescriptor}s
     */
    getRoles( __fetchOptions?: RequestOptions): Promise<Array<RoleDescriptor>>;
    /**
     * Get all available {@link RoleCategory}. Roles are grouped by
     * {@link RoleCategory}s.
     * @returns Set of {@link RoleCategory}s
     */
    getRolesCategories( __fetchOptions?: RequestOptions): Promise<Array<RolesCategory>>;
}

export declare class RolesClient extends ApiEndPoint implements IRoles {
    constructor(apiKey: string, base?: string);
    getRoles( __fetchOptions?: RequestOptions): Promise<Array<RoleDescriptor>>;
    getRolesCategories( __fetchOptions?: RequestOptions): Promise<Array<RolesCategory>>;
    getMetadata(): EndPointMetadata;
}
