import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ResourceTypeUidsClient.json';

export class ResourceTypeUidsClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/mailbox/uids');
    }
    async identifier(domain,  __fetchOptions = {}) {
        let __path = this.base + '/{domain}/_resource_type';
        __path = __path.replace('{domain}', encodeURIComponent(domain));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
