import { 
    TaskRef
} from "@bluemind/core.task.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Notes indexing API
 */
export interface INoteIndexMgmt {
    /**
     * Reindex a Note container
     * @returns {@link net.bluemind.core.task.api.TaskRef} which can be used to track
     *         this asynchronous operation
     */
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Reindex all Note containers
     * @returns {@link net.bluemind.core.task.api.TaskRef} which can be used to track
     *         this asynchronous operation
     */
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class NoteIndexMgmtClient extends ApiEndPoint implements INoteIndexMgmt {
    constructor(apiKey: string, base?: string);
    reindex(containerUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    reindexAll( __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
