import { 
    Message
} from "@bluemind/mailflow.common.api";

import { MailRuleDescriptor } from "./MailRuleDescriptor"; 
import { MailRuleActionAssignmentDescriptor } from "./MailRuleActionAssignmentDescriptor"; 
import { MailRuleActionAssignment } from "./MailRuleActionAssignment"; 
import { MailActionDescriptor } from "./MailActionDescriptor"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IMailflowRules {
    create(uid: string, assignment?: MailRuleActionAssignmentDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    evaluate(message?: Message,  __fetchOptions?: RequestOptions): Promise<Array<MailRuleActionAssignment>>;
    getAssignment(uid: string,  __fetchOptions?: RequestOptions): Promise<MailRuleActionAssignment>;
    listActions( __fetchOptions?: RequestOptions): Promise<Array<MailActionDescriptor>>;
    listAssignments( __fetchOptions?: RequestOptions): Promise<Array<MailRuleActionAssignment>>;
    listRules( __fetchOptions?: RequestOptions): Promise<Array<MailRuleDescriptor>>;
    update(uid: string, assignment?: MailRuleActionAssignmentDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class MailflowRulesClient extends ApiEndPoint implements IMailflowRules {
    domainUid: string;
    constructor(apiKey: string, domainUid: string, base?: string);
    create(uid: string, assignment?: MailRuleActionAssignmentDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    evaluate(message?: Message,  __fetchOptions?: RequestOptions): Promise<Array<MailRuleActionAssignment>>;
    getAssignment(uid: string,  __fetchOptions?: RequestOptions): Promise<MailRuleActionAssignment>;
    listActions( __fetchOptions?: RequestOptions): Promise<Array<MailActionDescriptor>>;
    listAssignments( __fetchOptions?: RequestOptions): Promise<Array<MailRuleActionAssignment>>;
    listRules( __fetchOptions?: RequestOptions): Promise<Array<MailRuleDescriptor>>;
    update(uid: string, assignment?: MailRuleActionAssignmentDescriptor,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
