
import { SimpleShardStats } from "./SimpleShardStats"; 
export type ShardStats = SimpleShardStats & {
    topMailbox?: Array<ShardStats.MailboxStats>;
    state?: ShardStats.State;
};
export namespace ShardStats {
    export type State =  "OK" |  "HALF_FULL" |  "FULL" |  "SPLIT_NEEDED";
    export const State : {
        readonly OK: State,
        readonly HALF_FULL: State,
        readonly FULL: State,
        readonly SPLIT_NEEDED: State
    };
    export type MailboxStats = {
        mailboxUid?: string;
        aliasName?: string;
        docCount?: number;
    };

}
