import { 
    Email
} from "@bluemind/core.foldershare.api";

export type Mailbox = {
    name?: string;
    system?: boolean;
    hidden?: boolean;
    archived?: boolean;
    type?: Mailbox.Type;
    routing?: Mailbox.Routing;
    emails?: Array<Email>;
    /**
     * {@link Server (bm/imap tagged) }
     */
    dataLocation?: string;
    /**
     * mail quota in KiB
     */
    quota?: number;
};
export namespace Mailbox {
    export type Type =  "user" |  "mailshare" |  "group" |  "resource";
    export const Type : {
        /**
         * A user mailbox
         */
        readonly user: Type,
        /**
         * A share mail folder
         */
        readonly mailshare: Type,
        /**
         * A group mailbox (for now, only deliver to users in group)
         */
        readonly group: Type,
        /**
         * A resource mailbox (deliver ics)
         */
        readonly resource: Type
    };
    export type Routing =  "internal" |  "external" |  "none";
    export const Routing : {
        readonly internal: Routing,
        readonly external: Routing,
        readonly none: Routing
    };

}
