import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './DomainSettingsClient.json';

export class DomainSettingsClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/domains/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async get( __fetchOptions = {}) {
        let __path = this.base + '/_settings';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async set(settings,  __fetchOptions = {}) {
        let __path = this.base + '/_settings';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (settings != null) {
            __options.body = JSON.stringify(settings);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
