import { 
    TaskRef
} from "@bluemind/core.task.api";
import { 
    ContainerChangeset,
    ItemValue
} from "@bluemind/core.container.api";

import { DirEntry } from "./DirEntry"; 
import { DirEntryQuery } from "./DirEntryQuery"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { 
    VCard
} from "@bluemind/addressbook.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IDirectory {
    /**
     * Get the domain's {@link ContainerChangeset}
     * @param since timestamp of the first change we want to retrieve
     * @returns {@link ContainerChangeset}
     */
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    /**
     * Delete {@link DirEntry} by path
     * @param path path of the directory entry (<b>domainUid/kind/entryUid</b>)<br>
     *             This action will fail if a shorter form of the path (like
     *             <b>domain</b> or <b>domain/kind</b>) is used and returns multiple
     *             entries.
     */
    delete(path: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Delete a {@link DirEntry} by uid
     */
    deleteByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    /**
     * Get {@link DirEntry} by uid
     * @param entryUid the unique {@link DirEntry} uid
     * @returns matching {@link DirEntry} or null if not found
     */
    findByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    /**
     * Get {@link DirEntry} by uid
     * @param entryUid the unique {@link DirEntry} uid
     * @returns matching {@link DirEntry} or null if not found
     */
    findItemValueByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<DirEntry>>;
    /**
     * Fetch a {@link DirEntry} by its email address
     * @param email the {@link DirEntry}'s email address
     * @returns the matching {@link DirEntry} or null, if not found
     */
    getByEmail(email: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    /**
     * 
     */
    getByRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    /**
     * Fetch {@link DirEntry}s by their path
     * @param path path of the directory entries <br>
     *             <b>domainUid/kind</b> to find all entries of a particular
     *             kind<br>
     *             <b>domainUid</b> to find all entries of a particular domain
     * @returns {@link DirEntry}s
     */
    getEntries(path?: string,  __fetchOptions?: RequestOptions): Promise<Array<DirEntry>>;
    /**
     * Fetch {@link DirEntry} by its path
     * @param path path of the directory entry <br>
     *             <b>domainUid/kind/entryUid</b> to find a particular entry <br>
     *             <b>domainUid/kind</b> to find all entries of a particular
     *             kind<br>
     *             <b>domainUid</b> to find all entries of a particular domain
     * @returns {@link DirEntry} or null if not found
     */
    getEntry(path?: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    /**
     * Get a {@link DirEntry}'s icon
     * @param entryUid the unique {@link DirEntry} uid
     * @returns the image data in PNG format or null, if no icon is associated to the
     *         {@link DirEntry}
     */
    getEntryIcon(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Get a {@link DirEntry}'s photo
     * @param entryUid the unique {@link DirEntry} uid
     * @returns the image data in PNG format or null, if no photo is associated to
     *         the {@link DirEntry}
     */
    getEntryPhoto(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Get a {@link DirEntry}'s icon
     * @param path path of the directory entry (<b>domainUid/kind/entryUid</b>)<br>
     *             This action will fail if a shorter form of the path (like
     *             <b>domain</b> or <b>domain/kind</b>) is used and returns multiple
     *             entries.
     * @returns the image data in PNG format or null, if no icon is associated to the
     *         {@link DirEntry}
     */
    getIcon(path: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    /**
     * Fetch a list of {@link net.bluemind.core.container.model}({@link DirEntry})
     * by their internal numerical ids
     * @param id list of internal numerical ids
     * @returns list of matching {@link DirEntry}'s
     */
    getMultiple(id?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    /**
     * Fetch a list of {@link net.bluemind.core.container.model}({@link DirEntry})
     * by their internal numerical ids without decorator executing db query
     * @param id list of internal numerical ids
     * @returns list of matching {@link DirEntry}'s
     */
    getMultipleLight(id?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    /**
     * Get all the roles associated to an {@link DirEntry}
     * @param entryUid the unique {@link DirEntry} uid
     * @returns a set containing all roles associated to a {@link DirEntry}
     */
    getRolesForDirEntry(entryUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Get all the roles associated to an {@link net.bluemind.directory.api.OrgUnit}
     * @returns a set containing all roles associated to an
     *         {@link net.bluemind.directory.api.OrgUnit}
     */
    getRolesForOrgUnit(ouUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    /**
     * Fetch the root {@link DirEntry}
     * @returns {@link DirEntry}
     */
    getRoot( __fetchOptions?: RequestOptions): Promise<DirEntry>;
    /**
     * Get {@link DirEntry}'s {@link net.bluemind.addressbook.api.VCard}
     * @param uid the entry uid
     */
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    /**
     * Search {@link DirEntry}s by {@link DirEntryQuery}
     * @param query the {@link DirEntryQuery} search parameters
     * @returns List of matching {@link DirEntry}s
     */
    search(query?: DirEntryQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<DirEntry>>>;
    /**
     * Search {@link DirEntry}s by {@link DirEntryQuery}
     * @param query the {@link DirEntryQuery} search parameters
     * @returns List of matching {@link DirEntry}s uids
     */
    searchUids(query?: DirEntryQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<string>>;
}

export declare class DirectoryClient extends ApiEndPoint implements IDirectory {
    domain: string;
    constructor(apiKey: string, domain: string, base?: string);
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    delete(path: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    deleteByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    findByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    findItemValueByEntryUid(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<DirEntry>>;
    getByEmail(email: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    getByRoles(roles?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    getEntries(path?: string,  __fetchOptions?: RequestOptions): Promise<Array<DirEntry>>;
    getEntry(path?: string,  __fetchOptions?: RequestOptions): Promise<DirEntry>;
    getEntryIcon(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getEntryPhoto(entryUid: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getIcon(path: string,  __fetchOptions?: RequestOptions): Promise<ArrayBuffer>;
    getMultiple(id?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    getMultipleLight(id?: Array<string>,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<DirEntry>>>;
    getRolesForDirEntry(entryUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getRolesForOrgUnit(ouUid: string,  __fetchOptions?: RequestOptions): Promise<Array<string>>;
    getRoot( __fetchOptions?: RequestOptions): Promise<DirEntry>;
    getVCard(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<VCard>>;
    search(query?: DirEntryQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<DirEntry>>>;
    searchUids(query?: DirEntryQuery,  __fetchOptions?: RequestOptions): Promise<ListResult<string>>;
    getMetadata(): EndPointMetadata;
}
