import { 
    TaskRef
} from "@bluemind/core.task.api";

import { RepairConfig } from "./RepairConfig"; 
import { MaintenanceOperation } from "./MaintenanceOperation"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IDirEntryMaintenance {
    /**
     * Retrieve available {@link MaintenanceOperation} applicable to a
     * {@link DirEntry}
     * @returns Set of {@link MaintenanceOperation}
     */
    getAvailableOperations( __fetchOptions?: RequestOptions): Promise<Array<MaintenanceOperation>>;
    /**
     * Execute {@link MaintenanceOperation} in "Repair" mode
     * @returns Reference to the net.bluemind.core.task.api.TaskRef
     */
    repair(config?: RepairConfig,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
}

export declare class DirEntryMaintenanceClient extends ApiEndPoint implements IDirEntryMaintenance {
    domain: string;
    entryUid: string;
    constructor(apiKey: string, domain: string, entryUid: string, base?: string);
    getAvailableOperations( __fetchOptions?: RequestOptions): Promise<Array<MaintenanceOperation>>;
    repair(config?: RepairConfig,  __fetchOptions?: RequestOptions): Promise<TaskRef>;
    getMetadata(): EndPointMetadata;
}
