
import { WipeMode } from "./WipeMode"; 
import { Device } from "./Device"; 
import { 
    ListResult
} from "@bluemind/core.foldershare.api";
import { 
    ItemValue
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IDevice {
    byIdentifier(identifier: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Device>>;
    create(uid: string, device?: Device,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Device>>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<Device>>>;
    setPartnership(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    unsetPartnership(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    unwipe(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, device?: Device,  __fetchOptions?: RequestOptions): Promise<void>;
    updateLastSync(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    wipe(uid: string, mode?: WipeMode,  __fetchOptions?: RequestOptions): Promise<void>;
}

export declare class DeviceClient extends ApiEndPoint implements IDevice {
    userUid: string;
    constructor(apiKey: string, userUid: string, base?: string);
    byIdentifier(identifier: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Device>>;
    create(uid: string, device?: Device,  __fetchOptions?: RequestOptions): Promise<void>;
    delete(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    deleteAll( __fetchOptions?: RequestOptions): Promise<void>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<Device>>;
    list( __fetchOptions?: RequestOptions): Promise<ListResult<ItemValue<Device>>>;
    setPartnership(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    unsetPartnership(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    unwipe(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    update(uid: string, device?: Device,  __fetchOptions?: RequestOptions): Promise<void>;
    updateLastSync(uid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    wipe(uid: string, mode?: WipeMode,  __fetchOptions?: RequestOptions): Promise<void>;
    getMetadata(): EndPointMetadata;
}
