import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ComputerTelephonyIntegrationClient.json';

export class ComputerTelephonyIntegrationClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, domainUid , userUid , base = '') {
        super(apiKey, base + '/api/cti/{domainUid}/{userUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.userUid = userUid;
        this.base = this.base.replace('{userUid}', encodeURIComponent(userUid));
    }
    async dial(number,  __fetchOptions = {}) {
        let __path = this.base + '/dial';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (number != null) {
            __url.searchParams.append("number", number);
        }
		return this.__fetchVoid(__url, __options);
    }
    async forward(component, phoneNumber,  __fetchOptions = {}) {
        let __path = this.base + '/forward/{component}';
        __path = __path.replace('{component}', encodeURIComponent(component));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (phoneNumber != null) {
            __url.searchParams.append("phoneNumber", phoneNumber);
        }
		return this.__fetchVoid(__url, __options);
    }
    async getStatus( __fetchOptions = {}) {
        let __path = this.base + '/status';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getUserEmails( __fetchOptions = {}) {
        let __path = this.base + '/users';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async setStatus(component, status,  __fetchOptions = {}) {
        let __path = this.base + '/status/{component}';
        __path = __path.replace('{component}', encodeURIComponent(component));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (status != null) {
            __options.body = JSON.stringify(status);
        }
		return this.__fetchVoid(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
