import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './OfflineMgmtClient.json';

export class OfflineMgmtClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, domainUid , ownerUid , base = '') {
        super(apiKey, base + '/api/offline/{domainUid}/{ownerUid}');
        this.domainUid = domainUid;
        this.base = this.base.replace('{domainUid}', encodeURIComponent(domainUid));
        this.ownerUid = ownerUid;
        this.base = this.base.replace('{ownerUid}', encodeURIComponent(ownerUid));
    }
    async allocateOfflineIds(idCount,  __fetchOptions = {}) {
        let __path = this.base + '/_allocateOfflineIds';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (idCount != null) {
            __url.searchParams.append("idCount", idCount);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
