import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './ContainerSyncClient.json';

export class ContainerSyncClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, containerUid , base = '') {
        super(apiKey, base + '/api/containers/_sync/{containerUid}');
        this.containerUid = containerUid;
        this.base = this.base.replace('{containerUid}', encodeURIComponent(containerUid));
    }
    async getLastSync( __fetchOptions = {}) {
        let __path = this.base + '/_last';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getNextSync( __fetchOptions = {}) {
        let __path = this.base + '/_next';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getSyncStatus( __fetchOptions = {}) {
        let __path = this.base + '/_status';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async sync( __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
