/**
 * This class represents a version number using the
 * <code>major.minor.release</code> format.
 */
export type VersionInfo = {
    /**
     * the major, eg. major.0.3456
     */
    major?: string;
    /**
     * the minor, eg. 1.minor.3456
     */
    minor?: string;
    /**
     * the release, eg. 1.0.release
     *
     * there can be a SNAPSHOT timestamp
     * for non-release build (eg. 4.1.0.202004021209)
     * It is ignored
     */
    release?: string;
    displayName?: string;
};
