
import { VFreebusyQuery } from "./VFreebusyQuery"; 
import { VFreebusy } from "./VFreebusy"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IVFreebusy {
    /**
     * Export the free/busy information
     * @param query {@link VFreebusyQuery}
     * @returns the free/busy information as {@link VFreebusy}
     */
    get(query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<VFreebusy>;
    /**
     * Export the free/busy information
     * @param query {@link VFreebusyQuery}
     * @returns the free/busy information as String
     */
    getAsString(query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class VFreebusyClient extends ApiEndPoint implements IVFreebusy {
    containerUid: string;
    constructor(apiKey: string, containerUid: string, base?: string);
    get(query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<VFreebusy>;
    getAsString(query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
