
import { VFreebusyQuery } from "./VFreebusyQuery"; 
import { VFreebusy } from "./VFreebusy"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IPublicFreebusy {
    /**
     * Export the free/busy information
     * @param query {@link VFreebusyQuery}
     * @returns the free/busy information as {@link VFreebusy}
     */
    get(email: string, callerUserUid?: string, callerDomain?: string, query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<VFreebusy>;
    /**
     * Export the free/busy information
     * @param query {@link VFreebusyQuery}
     * @returns the free/busy information as String
     */
    getAsString(email: string, callerUserUid?: string, callerDomain?: string, query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<string>;
    simple(email: string, callerUserUid?: string, callerDomain?: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class PublicFreebusyClient extends ApiEndPoint implements IPublicFreebusy {
    constructor(apiKey: string, base?: string);
    get(email: string, callerUserUid?: string, callerDomain?: string, query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<VFreebusy>;
    getAsString(email: string, callerUserUid?: string, callerDomain?: string, query?: VFreebusyQuery,  __fetchOptions?: RequestOptions): Promise<string>;
    simple(email: string, callerUserUid?: string, callerDomain?: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
