import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * To unify the management of changelogs, ACLs, client synchronization,
 * permissions and sharing, Bluemind stores all elements in a generic structure
 * called a container. All containers are identified by a unique ID. Some
 * containers are named (UID) in a specific manner to express a certain meaning.
 * 
 * 
 * Returns specific freebusy container UIDs.
 */
export interface IFreebusyUids {
    /**
     * Returns the default user freebusy UID
     * @returns default user freebusy UID
     */
    freebusyContainerUid(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
}

export declare class FreebusyUidsClient extends ApiEndPoint implements IFreebusyUids {
    constructor(apiKey: string, base?: string);
    freebusyContainerUid(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getMetadata(): EndPointMetadata;
}
