import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './CalendarsClient.json';

export class CalendarsClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, base = '') {
        super(apiKey, base + '/api/calendars');
    }
    async search(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async searchPendingCounters(calendars,  __fetchOptions = {}) {
        let __path = this.base + '/_search_counters';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (calendars != null) {
            __options.body = JSON.stringify(calendars);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
