
import { MailboxFolder } from "./MailboxFolder"; 
import { MailboxFolderSearchQuery } from "./MailboxFolderSearchQuery"; 
import { SearchResult } from "./SearchResult"; 
import { 
    ContainerChangeset,
    ItemFlagFilter,
    ItemChangelog,
    ItemValue,
    ItemVersion
} from "@bluemind/core.container.api";
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
/**
 * Database Read-only version of {@link IDbReplicatedMailboxes}
 */
export interface IReadOnlyMailboxFolders {
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    childrensOf(folderUid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getFullName(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    /**
     * @returns INBOX for user mailboxes or the toplevel mailshare folder
     */
    root( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    searchItems(query?: MailboxFolderSearchQuery,  __fetchOptions?: RequestOptions): Promise<SearchResult>;
    trash( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
}

export declare class ReadOnlyMailboxFoldersClient extends ApiEndPoint implements IReadOnlyMailboxFolders {
    container: string;
    constructor(apiKey: string, container: string, base?: string);
    all( __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    byName(name: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    changeset(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<string>>;
    changesetById(since?: number,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<number>>;
    childrensOf(folderUid: string,  __fetchOptions?: RequestOptions): Promise<Array<ItemValue<MailboxFolder>>>;
    filteredChangesetById(since?: number, arg1?: ItemFlagFilter,  __fetchOptions?: RequestOptions): Promise<ContainerChangeset<ItemVersion>>;
    getComplete(uid: string,  __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getFullName(uid: string,  __fetchOptions?: RequestOptions): Promise<string>;
    getVersion( __fetchOptions?: RequestOptions): Promise<number>;
    itemChangelog(uid: string, arg1?: number,  __fetchOptions?: RequestOptions): Promise<ItemChangelog>;
    root( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    searchItems(query?: MailboxFolderSearchQuery,  __fetchOptions?: RequestOptions): Promise<SearchResult>;
    trash( __fetchOptions?: RequestOptions): Promise<ItemValue<MailboxFolder>>;
    getMetadata(): EndPointMetadata;
}
