import { ApiEndPoint } from "@bluemind/api.commons";
import metadata from './MailboxFoldersByContainerClient.json';

export class MailboxFoldersByContainerClient extends ApiEndPoint {
    version = "5.4.2760";
    constructor(apiKey, container , base = '') {
        super(apiKey, base + '/api/mail_folders_container/{container}');
        this.container = container;
        this.base = this.base.replace('{container}', encodeURIComponent(container));
    }
    async all( __fetchOptions = {}) {
        let __path = this.base + '/_all';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async byName(name,  __fetchOptions = {}) {
        let __path = this.base + '/byName/{name}';
        __path = __path.replace('{name}', encodeURIComponent(name));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async changeset(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changeset';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async changesetById(since,  __fetchOptions = {}) {
        let __path = this.base + '/_changesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
		return this.__fetchContent(__url, __options);
    }
    async childrensOf(folderUid,  __fetchOptions = {}) {
        let __path = this.base + '/childensof/{folderUid}';
        __path = __path.replace('{folderUid}', encodeURIComponent(folderUid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async counters(folderItemIds,  __fetchOptions = {}) {
        let __path = this.base + '/_counters';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (folderItemIds != null) {
            __options.body = JSON.stringify(folderItemIds);
        }
		return this.__fetchContent(__url, __options);
    }
    async createBasic(value,  __fetchOptions = {}) {
        const __url = new URL(this.base, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchContent(__url, __options);
    }
    async createForHierarchy(hierarchyId, value,  __fetchOptions = {}) {
        let __path = this.base + '/id/{hierarchyId}';
        __path = __path.replace('{hierarchyId}', encodeURIComponent(hierarchyId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchContent(__url, __options);
    }
    async deepDelete(id,  __fetchOptions = {}) {
        let __path = this.base + '/deep/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async deleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async emptyFolder(id,  __fetchOptions = {}) {
        let __path = this.base + '/empty/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async filteredChangesetById(since, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/_filteredChangesetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (since != null) {
            __url.searchParams.append("since", since);
        }
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async getComplete(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/complete';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getCompleteById(id,  __fetchOptions = {}) {
        let __path = this.base + '/{id}/completeById';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getFullName(uid,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/fullname';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async getVersion( __fetchOptions = {}) {
        let __path = this.base + '/_version';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async importItems(folderDestinationId, mailboxItems,  __fetchOptions = {}) {
        let __path = this.base + '/importItems/{folderDestinationId}';
        __path = __path.replace('{folderDestinationId}', encodeURIComponent(folderDestinationId));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
        if (mailboxItems != null) {
            __options.body = JSON.stringify(mailboxItems);
        }
		return this.__fetchContent(__url, __options);
    }
    async itemChangelog(uid, arg1,  __fetchOptions = {}) {
        let __path = this.base + '/{uid}/_itemchangelog';
        __path = __path.replace('{uid}', encodeURIComponent(uid));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
        if (arg1 != null) {
            __options.body = JSON.stringify(arg1);
        }
		return this.__fetchContent(__url, __options);
    }
    async markFolderAsRead(id,  __fetchOptions = {}) {
        let __path = this.base + '/markAsRead/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('PUT', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async multipleGetById(arg0,  __fetchOptions = {}) {
        let __path = this.base + '/_mgetById';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (arg0 != null) {
            __options.body = JSON.stringify(arg0);
        }
		return this.__fetchContent(__url, __options);
    }
    async removeMessages(id,  __fetchOptions = {}) {
        let __path = this.base + '/removeMessages/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('DELETE', 'application/json', __fetchOptions);
		return this.__fetchVoid(__url, __options);
    }
    async root( __fetchOptions = {}) {
        let __path = this.base + '/_root';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async searchItems(query,  __fetchOptions = {}) {
        let __path = this.base + '/_search';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (query != null) {
            __options.body = JSON.stringify(query);
        }
		return this.__fetchContent(__url, __options);
    }
    async trash( __fetchOptions = {}) {
        let __path = this.base + '/_trash';
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('GET', 'application/json', __fetchOptions);
		return this.__fetchContent(__url, __options);
    }
    async updateById(id, value,  __fetchOptions = {}) {
        let __path = this.base + '/id/{id}';
        __path = __path.replace('{id}', encodeURIComponent(id));
        const __url = new URL(__path, self.location.origin);
        const __options = this.__getRequestInit('POST', 'application/json', __fetchOptions);
        if (value != null) {
            __options.body = JSON.stringify(value);
        }
		return this.__fetchContent(__url, __options);
    }
    getMetadata() {
        return metadata;
    }
}
