
import { APIKey } from "./APIKey"; 
import { ApiEndPoint, EndPointMetadata, RequestOptions } from "@bluemind/api.commons";
export interface IAPIKeys {
    /**
     * Creates an {@link APIKey} for the given core session. This will be usable as
     * a valid password to impersonate the user.
     * @param displayName the name of the {@link APIKey}
     * @returns an {@link APIKey} to impersonate the user
     */
    create(displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    /**
     * Deletes an {@link APIKey}
     * @param sid the {@link APIKey#sid}
     */
    delete(sid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(sid: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    /**
     * @returns a List of {@link APIKey}
     */
    list( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    listAll( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    /**
     * Creates an {@link APIKey} for the given core session using the provided key
     * as SID. The key will be usable as a valid password to impersonate the user.
     * @param key SID the name of the {@link APIKey}
     * @param displayName the name of the {@link APIKey}
     * @returns an {@link APIKey} to impersonate the user
     */
    store(key: string, displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
}

export declare class APIKeysClient extends ApiEndPoint implements IAPIKeys {
    constructor(apiKey: string, base?: string);
    create(displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    delete(sid: string,  __fetchOptions?: RequestOptions): Promise<void>;
    get(sid: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    list( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    listAll( __fetchOptions?: RequestOptions): Promise<Array<APIKey>>;
    store(key: string, displayName?: string,  __fetchOptions?: RequestOptions): Promise<APIKey>;
    getMetadata(): EndPointMetadata;
}
