/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class VCardCommunicationsTelGwtSerDer implements GwtSerDer<net.bluemind.addressbook.api.VCard.Communications.Tel> {

	private net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer parent = new  net.bluemind.addressbook.api.gwt.serder.VCardBasicAttributeGwtSerDer();
	public VCardCommunicationsTelGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.api.VCard.Communications.Tel deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.api.VCard.Communications.Tel ret = new net.bluemind.addressbook.api.VCard.Communications.Tel();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Communications.Tel ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue extJSON = json.get("ext");
		ret.ext =  GwtSerDerUtils.STRING.deserialize(extJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.api.VCard.Communications.Tel ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("ext")) {
			JSONValue extJSON = json.get("ext");
			ret.ext =  GwtSerDerUtils.STRING.deserialize(extJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.api.VCard.Communications.Tel o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Communications.Tel o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("ext",  GwtSerDerUtils.STRING.serialize( o.ext ));
	}

	public void serializeTo(net.bluemind.addressbook.api.VCard.Communications.Tel o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("ext")) {
			ret.put("ext",  GwtSerDerUtils.STRING.serialize( o.ext ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}