/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

package net.bluemind.addressbook.api.gwt.js;

import com.google.gwt.core.client.JavaScriptObject;

public class JsVCardKind extends JavaScriptObject {

	protected JsVCardKind() {}

   public final native String value() 
   /*-{
   	return this;
   }-*/;

	public static final native JsVCardKind group()
	/*-{
		return "group";
	}-*/;

	public static final native JsVCardKind individual()
	/*-{
		return "individual";
	}-*/;

	public static final native JsVCardKind location()
	/*-{
		return "location";
	}-*/;

	public static final native JsVCardKind org()
	/*-{
		return "org";
	}-*/;

	public static final JsVCardKind create(net.bluemind.addressbook.api.VCard.Kind value) {
		if (value == null) {
			return null;
		} else {
			switch (value) {
			case group:
				return group();
			case individual:
				return individual();
			case location:
				return location();
			case org:
				return org();
			default:
				return null;
			}
		}
	}
}