/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.store.kafka.index;

import org.apache.kafka.common.serialization.Deserializer;
import org.apache.kafka.common.serialization.Serde;
import org.apache.kafka.common.serialization.Serializer;

import net.bluemind.core.backup.continuous.index.ISerde;

public class SerDesHelper {

	public static <K> Serde<K> kafkaSerdes(ISerde<K> forK) {
		return new Serde<K>() {
			final Serializer<K> ser = (String topic, K data) -> {
				return forK.serialize(data);
			};
			final Deserializer<K> des = (String topic, byte[] data) -> {
				return forK.deserialize(data);
			};

			@Override
			public Serializer<K> serializer() {
				return ser;
			}

			@Override
			public Deserializer<K> deserializer() {
				return des;
			}
		};
	}

}
