/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2024
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.backend.mail.replica.api;

import net.bluemind.backend.mail.replica.api.MailboxReplicaRootDescriptor.Namespace;

public class SubtreeLocation {
	public String subtreeContainer;
	public String boxName;
	public String partition;
	public long folderItemId;

	/**
	 * shared/marketing or users/tom
	 */
	public String contName;

	public String toString() {
		return subtreeContainer + " " + boxName + ", partition: " + partition + ", contName: " + contName;
	}

	public Namespace namespace() {
		return subtreeContainer.contains("!user.") ? Namespace.users : Namespace.shared;
	}

}