package net.bluemind.core.backup.continuous.tools;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

import net.bluemind.core.container.model.BaseContainerDescriptor;
import net.bluemind.core.container.model.Container;
import net.bluemind.core.container.model.Item;
import net.bluemind.core.container.model.ItemVersion;
import net.bluemind.core.container.repository.IItemValueStore;
import net.bluemind.core.container.service.internal.ContainerStoreService;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;

public class DeletionHelper {

	private static class Dummy {

	}

	public static class DummyStore implements IItemValueStore<Dummy> {

		public DummyStore() {

		}

		@Override
		public void create(Item item, Dummy value) throws SQLException {
		}

		@Override
		public void update(Item item, Dummy value) throws SQLException {
		}

		@Override
		public void delete(Item item) throws SQLException {
		}

		@Override
		public Dummy get(Item item) throws SQLException {
			return null;
		}

		@Override
		public void deleteAll() throws SQLException {
		}

		@Override
		public boolean exists(Item item) throws SQLException {
			return false;
		}

		@Override
		public List<Dummy> getMultiple(List<Item> items) throws SQLException {
			return Collections.emptyList();
		}

	}

	private final ContainerStoreService<Dummy> css;

	private DeletionHelper(ContainerStoreService<Dummy> css) {
		this.css = css;
	}

	public void restoreDelete(ItemVersion iv) {
		css.restoreDelete(iv);
	}

	public static DeletionHelper forContainer(BaseContainerDescriptor parentContainer) {
		Container asCont = Container.create(parentContainer.uid, parentContainer.type, parentContainer.name,
				parentContainer.owner);
		asCont.id = parentContainer.internalId;
		ServerSideServiceProvider ssp = ServerSideServiceProvider.getProvider(SecurityContext.SYSTEM);
		BmContext ctx = ssp.getContext();
		ContainerStoreService<Dummy> css = new ContainerStoreService<DeletionHelper.Dummy>(ctx, asCont,
				new DummyStore());
		return new DeletionHelper(css);
	}

}
