/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.core.backup.continuous.restore.orphans;

import java.util.List;

import com.fasterxml.jackson.core.type.TypeReference;

import net.bluemind.authentication.api.APIKey;
import net.bluemind.authentication.repository.IAPIKeyStore;
import net.bluemind.core.backup.continuous.DataElement;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.context.SecurityContext;
import net.bluemind.core.rest.BmContext;
import net.bluemind.core.rest.ServerSideServiceProvider;
import net.bluemind.core.task.service.IServerTaskMonitor;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.repository.provider.RepositoryProvider;

public class RestoreApiKeys {

	private static final ValueReader<ItemValue<APIKey>> scReader = JsonUtils
			.reader(new TypeReference<ItemValue<APIKey>>() {
			});

	public void restore(IServerTaskMonitor monitor, List<DataElement> apiKeys) {
		monitor.log("Restore " + apiKeys.size() + " api keys");
		for (var de : apiKeys) {
			ItemValue<APIKey> iv = scReader.read(de.payload);
			monitor.log("api key: " + iv);
			try {
				if (iv.value != null && iv.value.subject != null && iv.value.domainUid != null) {
					BmContext ctx = ServerSideServiceProvider.getProvider(
							new SecurityContext("sid", iv.value.subject, List.of(), List.of(), iv.value.domainUid))
							.getContext();
					IAPIKeyStore store = RepositoryProvider.instance(IAPIKeyStore.class, ctx);
					store.create(iv.value);
					monitor.log("Created key for " + iv.value.displayName);
				}
			} catch (Exception e) {
				monitor.log("error on api key", e);
			}

		}
	}

}
