package net.bluemind.core.backup.continuous.restore.domains.replication;

import java.util.function.Supplier;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Suppliers;

import net.bluemind.backend.cyrus.partitions.CyrusPartition;
import net.bluemind.backend.mail.api.MessageBody;
import net.bluemind.backend.mail.replica.api.IDbMessageBodies;
import net.bluemind.backend.mail.replica.api.IMailReplicaUids;
import net.bluemind.core.backup.continuous.dto.VersionnedItem;
import net.bluemind.core.backup.continuous.model.RecordKey;
import net.bluemind.core.backup.continuous.restore.domains.RestoreDomainType;
import net.bluemind.core.backup.continuous.restore.domains.RestoreLogger;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.network.topology.Topology;

public class RestoreMessageBody implements RestoreDomainType {

	private static final Supplier<CyrusPartition> PART = Suppliers
			.memoize(() -> CyrusPartition.forServerAndDomain(Topology.get().any("mail/imap").uid, "global.virt"));

	private RestoreLogger log;
	private boolean onlyFromBodiesStore;
	private final Supplier<IDbMessageBodies> api;

	private static final ValueReader<VersionnedItem<MessageBody>> reader = JsonUtils
			.reader(new TypeReference<VersionnedItem<MessageBody>>() {
			});

	/**
	 * 
	 * @param log
	 * @param target
	 * @param restoreBodiesFromTopic: we may have bodies in two topics:
	 *                                -bodies.store and normal topic. if the bodies
	 *                                store is fully populated, no need to restore
	 *                                bodies from the main topic
	 */
	public RestoreMessageBody(RestoreLogger log, IServiceProvider target, boolean onlyFromBodiesStore) {
		this.onlyFromBodiesStore = onlyFromBodiesStore;
		this.log = log;
		this.api = Suppliers.memoize(() -> target.instance(IDbMessageBodies.class, PART.get().name));
	}

	@Override
	public String type() {
		return IMailReplicaUids.REPAIR_MESSAGE_BODIES;
	}

	@Override
	public void restore(RecordKey key, String payload) {
		// bodies are migrated, ignore the old ones
		if (onlyFromBodiesStore && !key.uid.contains("_at_bodies.store_")) {
			return;
		}
		IDbMessageBodies bodyApi = api.get();
		if (!"DELETE".equals(key.operation)) {
			VersionnedItem<MessageBody> body = reader.read(payload);
			log.create(type(), key);

			bodyApi.restore(body, true);
		}
	}

}
