/* BEGIN LICENSE
 * Copyright © Blue Mind SAS, 2012-2021
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.core.backup.continuous.restore.domains;

import com.fasterxml.jackson.core.type.TypeReference;

import net.bluemind.core.backup.continuous.dto.VersionnedItem;
import net.bluemind.core.backup.continuous.model.RecordKey;
import net.bluemind.core.backup.continuous.restore.domains.crud.CrudItemRestore;
import net.bluemind.core.container.api.ContainerHierarchyNode;
import net.bluemind.core.container.api.IFlatHierarchyUids;
import net.bluemind.core.container.api.IRestoreItemCrudSupport;
import net.bluemind.core.container.api.internal.IInternalContainersFlatHierarchy;
import net.bluemind.core.container.model.ItemValue;
import net.bluemind.core.rest.IServiceProvider;
import net.bluemind.core.utils.JsonUtils;
import net.bluemind.core.utils.JsonUtils.ValueReader;
import net.bluemind.domain.api.Domain;

public class RestoreFlatHierarchy extends CrudItemRestore<ContainerHierarchyNode> {

	private static final ValueReader<VersionnedItem<ContainerHierarchyNode>> mrReader = JsonUtils
			.reader(new TypeReference<VersionnedItem<ContainerHierarchyNode>>() {
			});
	private IServiceProvider target;

	public RestoreFlatHierarchy(RestoreLogger log, ItemValue<Domain> domain, IServiceProvider target,
			RestoreState state) {
		super(log, domain, state);
		this.target = target;
	}

	@Override
	public String type() {
		return IFlatHierarchyUids.TYPE;
	}

	@Override
	protected ValueReader<VersionnedItem<ContainerHierarchyNode>> reader() {
		return mrReader;
	}

	@Override
	protected IRestoreItemCrudSupport<ContainerHierarchyNode> api(ItemValue<Domain> domain, RecordKey key) {
		return target.instance(IInternalContainersFlatHierarchy.class, domain.uid, key.owner);
	}

}
