/* BEGIN LICENSE
  * Copyright © Blue Mind SAS, 2012-2025
  *
  * This file is part of BlueMind. BlueMind is a messaging and collaborative
  * solution.
  *
  * This program is free software; you can redistribute it and/or modify
  * it under the terms of either the GNU Affero General Public License as
  * published by the Free Software Foundation (version 3 of the License).
  *
  * This program is distributed in the hope that it will be useful,
  * but WITHOUT ANY WARRANTY; without even the implied warranty of
  * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  *
  * See LICENSE.txt
  * END LICENSE
  */
package net.bluemind.dataprotect.calendar;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;

import net.bluemind.calendar.api.internal.CalendarHistory;
import net.bluemind.dataprotect.common.backup.BackupContainerItemDescriptor;
import net.bluemind.dataprotect.common.backup.JsonReadWrite;
import net.bluemind.dataprotect.common.backup.RestorableContainerItemBackupItem;
import net.bluemind.dataprotect.common.backup.RestorableItemBackupItem;

public class CalendarRestorableBackupItem<T> extends RestorableContainerItemBackupItem<T> {
	private Path histPath;
	public RestorableItemBackupItem<CalendarHistory> calendarHistory;
	private InputStream historyStream;

	public CalendarRestorableBackupItem(BackupContainerItemDescriptor<T> backupDescriptor) {
		super(backupDescriptor);
	}

	public CalendarRestorableBackupItem(BackupContainerItemDescriptor<T> backupDescriptor, Path filePath, Path histPath)
			throws IOException {
		super(backupDescriptor, filePath);
		this.histPath = histPath;
		this.calendarHistory = readHistory();
	}

	private RestorableItemBackupItem<CalendarHistory> readHistory() throws IOException {
		if (this.histPath == null || !Files.exists(this.histPath)) {
			return null;
		}

		try (InputStream in = Files.newInputStream(histPath, StandardOpenOption.READ)) {
			return new RestorableItemBackupItem(JsonReadWrite.readerCalHistory().read(in.readAllBytes()));
		}
	}

	public void readHistoryStreamContent(byte[] histData) {
		this.historyStream = new ByteArrayInputStream(histData);
	}
}
