import { extensions } from "@bluemind/extensions";
import { camelCase } from "@bluemind/commons/utils/string";
import BaseUri from "./BaseUriRegExp";
import EmbeddedAppWrapper from "./EmbeddedAppWrapper";

type Application = {
    name: string;
    href: string;
    priority?: string;
    role?: string;
    help?: string;
    shortcut?: boolean;
    hidden?: boolean;
    target?: boolean;
    description?: string;
    icon: ApplicationIcon;
};

type EmbedApplication = Application & {
    embed: {
        src: string;
    };
};
type ApplicationIcon = {
    url?: { href: string };
    svg?: string;
};
const applications = extensions.get("net.bluemind.webapp", "application") || [];
const routes = applications.filter(isEmbedded).map(toRoute);

export default routes;

function toRoute({ name, href: route, embed: { src } }: EmbedApplication) {
    const path = route.replace(BaseUri, "");
    const sanitized = camelCase(name);
    return {
        name: `embedded:${sanitized}:root`,
        path,
        component: EmbeddedAppWrapper(`Embedded${pascalCase(sanitized)}App`, src)
    };
}

function isEmbedded(application: Application): boolean {
    return BaseUri.test(application.href) && (application as EmbedApplication).embed !== undefined;
}

function pascalCase(str: string) {
    return str.charAt(0).toUpperCase() + str.slice(1);
}
