import Roles from "@bluemind/roles";
import { mapExtensions } from "@bluemind/extensions";

export default function (vueI18N) {
    const tasks = mapExtensions("net.bluemind.webapp", ["application"]).application?.find(
        ({ $bundle }) => $bundle === "net.bluemind.webmodules.todolist"
    );
    return {
        id: "tasks",
        name: tasks?.name,
        icon: tasks?.icon,
        priority: tasks?.priority,
        visible: { name: "RoleCondition", args: [Roles.HAS_CALENDAR] },
        categories: [myTodoLists(vueI18N), otherTodoLists(vueI18N)]
    };
}

function myTodoLists(vueI18N) {
    return {
        id: "my_todo_lists",
        name: vueI18N.t("common.my_todo_lists"),
        icon: "todolist",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.my_todo_lists"),
                fields: [{ id: "field", component: { name: "PrefManageMyTodoLists" } }]
            }
        ]
    };
}

function otherTodoLists(vueI18N) {
    return {
        id: "other_todo_lists",
        name: vueI18N.t("common.other_todo_lists"),
        icon: "todolist-network",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.other_todo_lists"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefManageOtherTodoLists" }
                    }
                ]
            }
        ]
    };
}
