import Roles from "@bluemind/roles";
import { mapExtensions } from "@bluemind/extensions";

export default function (vueI18N) {
    const contact = mapExtensions("net.bluemind.webapp", ["application"]).application?.find(
        ({ $bundle }) => $bundle === "net.bluemind.webmodules.contact"
    );
    return {
        id: "contacts",
        name: vueI18N.t("common.application.contacts"),
        icon: contact?.icon,
        priority: contact?.priority,
        visible: { name: "RoleCondition", args: [Roles.HAS_MAIL] },
        categories: [myAddressBooks(vueI18N), otherAddressBooks(vueI18N)]
    };
}

function myAddressBooks(vueI18N) {
    return {
        id: "my_address_books",
        name: vueI18N.t("common.my_address_books"),
        icon: "addressbook",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.my_address_books"),
                fields: [{ id: "field", component: { name: "PrefManageMyAddressBooks" } }]
            }
        ]
    };
}

function otherAddressBooks(vueI18N) {
    return {
        id: "other_address_books",
        name: vueI18N.t("common.other_address_books"),
        icon: "addressbook-network",
        groups: [
            {
                id: "group",
                name: vueI18N.t("common.other_address_books"),
                fields: [
                    {
                        id: "field",
                        component: { name: "PrefManageOtherAddressBooks" }
                    }
                ]
            }
        ]
    };
}
