<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * ErrorCode.
 */
abstract class ErrorCode {

  const UNKNOWN = 'UNKNOWN';
  const PERMISSION_DENIED = 'PERMISSION_DENIED';
  const FAILURE = 'FAILURE';
  const INVALID_ID = 'INVALID_ID';
  const INVALID_PARAMETER = 'INVALID_PARAMETER';
  const AUTHENTICATION_FAIL = 'AUTHENTICATION_FAIL';
  const SQL_ERROR = 'SQL_ERROR';
  const NOT_FOUND = 'NOT_FOUND';
  const ALREADY_EXISTS = 'ALREADY_EXISTS';
  const FORBIDDEN = 'FORBIDDEN';
  const ENTITY_TOO_LARGE = 'ENTITY_TOO_LARGE';
  const INVALID_QUERY = 'INVALID_QUERY';
  const INVALID_XML_RECEIVED = 'INVALID_XML_RECEIVED';
  const CHILD_GROUP_MUST_EXIST = 'CHILD_GROUP_MUST_EXIST';
  const CANT_DELETE_MYSELF = 'CANT_DELETE_MYSELF';
  const DELEGATION_RESTRICTION = 'DELEGATION_RESTRICTION';
  const INVALID_PASSWORD = 'INVALID_PASSWORD';
  const LOGIN_ALREADY_USED = 'LOGIN_ALREADY_USED';
  const INVALID_LOGIN = 'INVALID_LOGIN';
  const EMPTY_LASTNAME = 'EMPTY_LASTNAME';
  const EMPTY_VACATION_MESSAGE = 'EMPTY_VACATION_MESSAGE';
  const VACATION_WITHOUT_MAILBOX = 'VACATION_WITHOUT_MAILBOX';
  const FORWARDING_WITHOUT_MAILBOX = 'FORWARDING_WITHOUT_MAILBOX';
  const FORWARDING_INVALID_EMAIL = 'FORWARDING_INVALID_EMAIL';
  const INVALID_MAIL_SERVER = 'INVALID_MAIL_SERVER';
  const INVALID_GROUP_NAME = 'INVALID_GROUP_NAME';
  const FORWARDING_TO_OWN_MAILBOX = 'FORWARDING_TO_OWN_MAILBOX';
  const SAME_PARENT_AND_CHILD_GROUP = 'SAME_PARENT_AND_CHILD_GROUP';
  const INCLUSION_GROUP_LOOP = 'INCLUSION_GROUP_LOOP';
  const EMAIL_ALREADY_USED = 'EMAIL_ALREADY_USED';
  const INVALID_EMAIL = 'INVALID_EMAIL';
  const MAIL_QUOTA_OVER_DOMAIN_LIMIT = 'MAIL_QUOTA_OVER_DOMAIN_LIMIT';
  const NOT_GLOBAL_ADMIN = 'NOT_GLOBAL_ADMIN';
  const DOMAIN_NAME_ALREADY_USED = 'DOMAIN_NAME_ALREADY_USED';
  const INVALID_MAILSHARE_NAME = 'INVALID_MAILSHARE_NAME';
  const INVALID_RESOURCE_NAME = 'INVALID_RESOURCE_NAME';
  const OLD_PASSWORD_WRONG = 'OLD_PASSWORD_WRONG';
  const OLD_PASSWORD_SAME_AS_NEW = 'OLD_PASSWORD_SAME_AS_NEW';
  const IP_ADDRESS_ALREADY_USED = 'IP_ADDRESS_ALREADY_USED';
  const MBOX_RENAME_FAILED = 'MBOX_RENAME_FAILED';
  const INVALID_HOST_NAME = 'INVALID_HOST_NAME';
  const EMPTY_EVENT_TITLE = 'EMPTY_EVENT_TITLE';
  const NO_DURATION_EVENT = 'NO_DURATION_EVENT';
  const NO_EVENT_DATE = 'NO_EVENT_DATE';
  const NO_EVENT_TYPE = 'NO_EVENT_TYPE';
  const EVENT_PRIVACY_INVALID = 'EVENT_PRIVACY_INVALID';
  const EVENT_ERROR = 'EVENT_ERROR';
  const CALENDAR_AUTHORISATION_ERROR = 'CALENDAR_AUTHORISATION_ERROR';
  const CONTACT_DOMAIN_FORBIDDEN = 'CONTACT_DOMAIN_FORBIDDEN';
  const EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE = 'EVENT_ENDREPEAT_PRIOR_TO_EVENT_DATE';
  const INVALID_DOMAIN_NAME = 'INVALID_DOMAIN_NAME';
  const GROUP_NAME_ALREADY_USED = 'GROUP_NAME_ALREADY_USED';
  const INVALID_VACATION_RANGE = 'INVALID_VACATION_RANGE';
  const EMPTY_DLIST_LABEL = 'EMPTY_DLIST_LABEL';
  const EMPTY_DLIST_FOLDER = 'EMPTY_DLIST_FOLDER';
  const DLIST_LOOP = 'DLIST_LOOP';
  const CANT_UPDATE_ACL_IMPLICIT_RIGHTS = 'CANT_UPDATE_ACL_IMPLICIT_RIGHTS';
  const USER_SPLIT_REQUIRES_SPLIT_DOMAIN = 'USER_SPLIT_REQUIRES_SPLIT_DOMAIN';
  const SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN = 'SLAVE_RELAY_REQUIRES_SPLIT_DOMAIN';
  const INVALID_USER_LDAP_FILTER = 'INVALID_USER_LDAP_FILTER';
  const SEC_GROUP_RM = 'SEC_GROUP_RM';
  const NOT_IN_GLOBAL_DOMAIN = 'NOT_IN_GLOBAL_DOMAIN';
  const NO_BACKUP_SERVER_FOUND = 'NO_BACKUP_SERVER_FOUND';
  const OPERATION_ALREADY_RUNNING = 'OPERATION_ALREADY_RUNNING';
  const INVALID_AD_HOST_NAME = 'INVALID_AD_HOST_NAME';
  const JOB_FINISHED = 'JOB_FINISHED';
  const INVALID_LICENSE = 'INVALID_LICENSE';
  const HSM_MISSING_POLICY = 'HSM_MISSING_POLICY';
  const INCOMPATIBLE_SMTP_TAGS = 'INCOMPATIBLE_SMTP_TAGS';
  const INVALID_MAILBOX_NAME = 'INVALID_MAILBOX_NAME';
  const TAG_ALREADY_EXIST = 'TAG_ALREADY_EXIST';
  const INVALID_LINKED_MAILSHARE = 'INVALID_LINKED_MAILSHARE';
  const MAILSHARE_GROUP_LINKED = 'MAILSHARE_GROUP_LINKED';
  const SERVER_NOT_FOUND = 'SERVER_NOT_FOUND';
  const DEPRECATED = 'DEPRECATED';
  const INVALID_GROUP_MEMBER = 'INVALID_GROUP_MEMBER';
  const EMPTY_EVENT_ATTACHMENT_VALUE = 'EMPTY_EVENT_ATTACHMENT_VALUE';
  const TIMEOUT = 'TIMEOUT';
  const VERSION_HAS_CHANGED = 'VERSION_HAS_CHANGED';
  const MULTIPLE_EVENT_COUNTERS = 'MULTIPLE_EVENT_COUNTERS';
  const EVENT_ACCEPTS_NO_COUNTERS = 'EVENT_ACCEPTS_NO_COUNTERS';
  const EVENT_WEEKDAY_INVALID = 'EVENT_WEEKDAY_INVALID';
  const EVENT_DUPLICATED_RECURID = 'EVENT_DUPLICATED_RECURID';
  const MAX_ITEM_COUNT = 'MAX_ITEM_COUNT';
  const INVALID_PEM_CERTIFICATE = 'INVALID_PEM_CERTIFICATE';
  const INVALID_AUTH_PARAMETER = 'INVALID_AUTH_PARAMETER';

}