/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.mailbox.api.rules.actions.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class MailFilterRuleActionCopyGwtSerDer implements GwtSerDer<net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy> {

	private net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer parent = new  net.bluemind.mailbox.api.rules.actions.gwt.serder.MailFilterRuleActionGwtSerDer();
	public MailFilterRuleActionCopyGwtSerDer( ) {
	}

	@Override
	public net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy ret = new net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy ret, JSONObject json) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.deserializeTo( ret, json, propertiesToIgnore);
		JSONValue subtreeJSON = json.get("subtree");
		ret.subtree =  GwtSerDerUtils.STRING.deserialize(subtreeJSON);
		JSONValue idJSON = json.get("id");
		ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		JSONValue folderJSON = json.get("folder");
		ret.folder =  GwtSerDerUtils.STRING.deserialize(folderJSON);
	}

	public void deserializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.deserializeTo( ret, json, propertiesToIgnore);
		if (!childPropertiesToIgnore.contains("subtree")) {
			JSONValue subtreeJSON = json.get("subtree");
			ret.subtree =  GwtSerDerUtils.STRING.deserialize(subtreeJSON);
		}
		if (!childPropertiesToIgnore.contains("id")) {
			JSONValue idJSON = json.get("id");
			ret.id =  GwtSerDerUtils.LONG.deserialize(idJSON);
		}
		if (!childPropertiesToIgnore.contains("folder")) {
			JSONValue folderJSON = json.get("folder");
			ret.folder =  GwtSerDerUtils.STRING.deserialize(folderJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy o, JSONObject ret) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		parent.serializeTo( o, ret, propertiesToIgnore);

		ret.put("subtree",  GwtSerDerUtils.STRING.serialize( o.subtree ));
		ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		ret.put("folder",  GwtSerDerUtils.STRING.serialize( o.folder ));
	}

	public void serializeTo(net.bluemind.mailbox.api.rules.actions.MailFilterRuleActionCopy o, JSONObject ret, Set<String> childPropertiesToIgnore) {
		Set<String> propertiesToIgnore = propertiesToIgnore();
		propertiesToIgnore.addAll(childPropertiesToIgnore);
		parent.serializeTo( o, ret, propertiesToIgnore);

		if (!childPropertiesToIgnore.contains("subtree")) {
			ret.put("subtree",  GwtSerDerUtils.STRING.serialize( o.subtree ));
		}
		if (!childPropertiesToIgnore.contains("id")) {
			ret.put("id",  GwtSerDerUtils.LONG.serialize( o.id ));
		}
		if (!childPropertiesToIgnore.contains("folder")) {
			ret.put("folder",  GwtSerDerUtils.STRING.serialize( o.folder ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}