package net.bluemind.directory.hollow.datamodel.consumer.multicore.index.impl;

import java.util.List;
import java.util.Optional;

import net.bluemind.directory.hollow.datamodel.AddressBookRecordIndexOnly;
import net.bluemind.directory.hollow.datamodel.consumer.multicore.index.DeserializerIndexMultiMap;

public class ByEmail extends DeserializerIndexMultiMap {

	@Override
	public List<String> getIndexKeys(AddressBookRecordIndexOnly addressBookRecord) {
		return addressBookRecord.getEmails().stream().map(email -> email.getAddress()).toList();
	}

	@Override
	public Optional<String> simpleQueryFieldName() {
		return Optional.empty();
	}

}
