package net.bluemind.milter;

public record Status(StatusCode statusCode, String rcode, String xcode, String[] messageLines) {
	public enum StatusCode {
		CONTINUE, REJECT, DISCARD, CUSTOM;
	}

	public static final Status CONTINUE = new Status(StatusCode.CONTINUE, null, null, null);
	public static final Status REJECT = new Status(StatusCode.REJECT, null, null, null);
	public static final Status DISCARD = new Status(StatusCode.DISCARD, null, null, null);

	public static Status getContinue() {
		return CONTINUE;
	}

	public static Status getReject() {
		return REJECT;
	}

	public static Status getDiscard() {
		return DISCARD;
	}

	public static Status getCustom(String rcode, String xcode, String[] messageLines) {
		return new Status(StatusCode.CUSTOM, rcode, xcode, messageLines);
	}

	@Override
	public String toString() {
		if (statusCode == StatusCode.CUSTOM) {
			return rcode + " " + xcode + " - " + String.join(", ", messageLines);
		}

		return statusCode.name();
	}
}
