/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */
package net.bluemind.addressbook.ldap.api.gwt.serder;

import java.util.Set;
import java.util.HashSet;

import net.bluemind.core.commons.gwt.GwtSerDer;
import net.bluemind.core.commons.gwt.GwtSerDerUtils;

import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONValue;

public class ConnectionStatusGwtSerDer implements GwtSerDer<net.bluemind.addressbook.ldap.api.ConnectionStatus> {

	public ConnectionStatusGwtSerDer( ) {
	}

	@Override
	public net.bluemind.addressbook.ldap.api.ConnectionStatus deserialize(JSONValue value) {
		if( value == null ) {
			return null;
		}

		JSONObject json = value.isObject();
		if (json == null) {
			return null;
		}

		net.bluemind.addressbook.ldap.api.ConnectionStatus ret = new net.bluemind.addressbook.ldap.api.ConnectionStatus();
		deserializeTo(ret, json);
		return ret;
	}

	public void deserializeTo(net.bluemind.addressbook.ldap.api.ConnectionStatus ret, JSONObject json) {
		JSONValue statusJSON = json.get("status");
		ret.status =  GwtSerDerUtils.BOOLEAN.deserialize(statusJSON);
		JSONValue errorCodeJSON = json.get("errorCode");
		ret.errorCode =  new net.bluemind.addressbook.ldap.api.fault.gwt.serder.LdapAddressBookErrorCodeGwtSerDer().deserialize(errorCodeJSON);
		JSONValue errorMsgJSON = json.get("errorMsg");
		ret.errorMsg =  GwtSerDerUtils.STRING.deserialize(errorMsgJSON);
	}

	public void deserializeTo(net.bluemind.addressbook.ldap.api.ConnectionStatus ret, JSONObject json, Set<String> childPropertiesToIgnore) {
		if (!childPropertiesToIgnore.contains("status")) {
			JSONValue statusJSON = json.get("status");
			ret.status =  GwtSerDerUtils.BOOLEAN.deserialize(statusJSON);
		}
		if (!childPropertiesToIgnore.contains("errorCode")) {
			JSONValue errorCodeJSON = json.get("errorCode");
			ret.errorCode =  new net.bluemind.addressbook.ldap.api.fault.gwt.serder.LdapAddressBookErrorCodeGwtSerDer().deserialize(errorCodeJSON);
		}
		if (!childPropertiesToIgnore.contains("errorMsg")) {
			JSONValue errorMsgJSON = json.get("errorMsg");
			ret.errorMsg =  GwtSerDerUtils.STRING.deserialize(errorMsgJSON);
		}
	}


	@Override
	public JSONValue serialize(net.bluemind.addressbook.ldap.api.ConnectionStatus o) {
		if (o == null) {
			return null;
		}

		JSONObject ret = new JSONObject();
		serializeTo( o, ret);
		return ret;
	}

	public void serializeTo(net.bluemind.addressbook.ldap.api.ConnectionStatus o, JSONObject ret) {

		ret.put("status",  GwtSerDerUtils.BOOLEAN.serialize( o.status ));
		ret.put("errorCode",  new net.bluemind.addressbook.ldap.api.fault.gwt.serder.LdapAddressBookErrorCodeGwtSerDer().serialize( o.errorCode ));
		ret.put("errorMsg",  GwtSerDerUtils.STRING.serialize( o.errorMsg ));
	}

	public void serializeTo(net.bluemind.addressbook.ldap.api.ConnectionStatus o, JSONObject ret, Set<String> childPropertiesToIgnore) {

		if (!childPropertiesToIgnore.contains("status")) {
			ret.put("status",  GwtSerDerUtils.BOOLEAN.serialize( o.status ));
		}
		if (!childPropertiesToIgnore.contains("errorCode")) {
			ret.put("errorCode",  new net.bluemind.addressbook.ldap.api.fault.gwt.serder.LdapAddressBookErrorCodeGwtSerDer().serialize( o.errorCode ));
		}
		if (!childPropertiesToIgnore.contains("errorMsg")) {
			ret.put("errorMsg",  GwtSerDerUtils.STRING.serialize( o.errorMsg ));
		}
	}


	public Set<String> propertiesToIgnore() {
		return new HashSet<>();
	}
}