<?php

/* BEGIN LICENSE
 * Copyright Â© Blue Mind SAS, 2012-2016
 *
 * This file is part of BlueMind. BlueMind is a messaging and collaborative
 * solution.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of either the GNU Affero General Public License as
 * published by the Free Software Foundation (version 3 of the License).
 *
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *
 * See LICENSE.txt
 * END LICENSE
 */

namespace BM;

/**
 * VEventCounter.
 */
class VEventCounter  {

  /*
   * @type VEventCounterCounterOriginator
   */
  public $originator;

  /*
   * @type VEventOccurrence
   */
  public $counter;

  /*
   * Constructor
   */
  public function __construct() {
    $this->originator =   new VEventCounterCounterOriginator();
    $this->counter =   new VEventOccurrence();
  }

  public function toMap() {
    $data = array(    
        "originator" => empty($this->originator) ? null : $this->originator,    
        "counter" => empty($this->counter) ? null : $this->counter);
    return $data;
  }
  
  public function serialize() {
    $parentMap = array();
    $data = $this->toMap();

    $d = array_merge($parentMap, $data);

    return json_encode($d);
  }

}
